/**********************************************************************
 * Copyright (c) 2006,2007 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal.controlproviders;

import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;
import org.eclipse.tptp.platform.jvmti.client.internal.controlproviders.TIAgentControlProvider.TIAgentStateModifier;
import org.eclipse.tptp.platform.jvmti.client.internal.controlproviders.TIAgentControlProvider.RunGCControlItem;
import org.eclipse.tptp.platform.jvmti.client.internal.controlproviders.TIProcessControlProvider.TIProcessStateModifier;
import org.eclipse.tptp.trace.ui.provisional.control.provider.AbstractAgentToolbarProvider;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IAgentStateModifier;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlItem;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IProcessStateModifier;


/**
 * The toolbar control provider for the TI agent.
 * 
 * @author Ali Mehregani
 */
public class TIAgentToolbarControlProvider extends AbstractAgentToolbarProvider
{
	public static final String GC_TOOLBAR_ITEM = "org.eclipse.tptp.trace.jvmti.client.internal.monitorsview.toolbar.runGC";

	private IControlItem garbageCollectionControlItem;


	public IProcessStateModifier getProcessStateModifier()
	{		
		return TIProcessStateModifier.getInstance();
	}
	
	public IAgentStateModifier getAgentStateModifier()
	{
		return TIAgentStateModifier.getInstance();
	}

    protected void initializeControlItems() {
	super.initializeControlItems();
	addControlItem(createGCControlItem());
    }

    protected IControlItem createGCControlItem() {
	if (garbageCollectionControlItem != null)
	    return garbageCollectionControlItem;

	garbageCollectionControlItem = makeToolbarReady(new RunGCControlItem(),
		GC_TOOLBAR_ITEM, CommonUITraceConstants.PROFILE_GC_GROUP,
		TraceUIImages.INSTANCE.getImageDescriptor("d",
			TraceUIImages.IMG_GC));
	return garbageCollectionControlItem;
    }
}
