/**********************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.tptp.trace.ui.provisional.launcher.IParameterExtractor;


/**
 * Provides the expected getter methods whose values are needed to perform a profile
 * launch.
 * 
 * @author Ali Mehregani
 */
public interface ILauncherParameterProvider extends IParameterExtractor
{
	/**
	 * Return the host name where the launch should occur.
	 * 
	 * @return The host name
	 */
	public String getHostName();
	
	
	/**
	 * Return the port number of the Agent Controller
	 * 
	 * @return The port number of the Agent Controller
	 */
	public int getPortNumber();
	

	/**
	 * Returns the current working director that should be used when launching
	 * the profile session
	 * 
	 * @return The location where the launch should be started.
	 */
	public String getLocation();
	
	
	/**
	 * Return the classpath for the profiling session
	 * 
	 * @return The classpath
	 */
	public String getClassPath();
	
	
	/**
	 * Invoked prior to the launch of the profiling session
	 *
	 * @param configuration The launch configuration
	 * @param mode The mode of the launch 
	 * @param launch The launch 
	 * @param monitor The progress monitor
	 * 
	 * @throws CoreException In case of any unexpected error
	 */
	public void preLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException;
}
