/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal.launcher;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.launcher.ILauncherHandler;
import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.agent.IAgentListener;
import org.eclipse.tptp.platform.probekit.launch.launchpad.LaunchPadExtensionSlot;
/**
 * A listener class which waits for the AgentActive signal from the
 * monitored agent. Before the RESUME command is sent, we want to
 * give control to the Probekit Launcher so that the probe script
 * and probe class files can be sent. Once they are sent, RESUME is
 * called and the agent can run.
 * 
 * @author Liz Dancy
 *
 */
	public class ProbeControlListener implements IAgentListener
	{
		IAgent controlAgent =null;
		Map launcherHandlers;
		ILaunchConfiguration config;
		
		
		//necessary in order to retrieve the LauncherHandlers so we
		//can identify the probekit launchpad and give it control
		
		public ProbeControlListener( ILaunchConfiguration callingConfiguration)
		{
			config =callingConfiguration;
		
		}
		
		public void error(IAgent agent, String errorMessage)
		{
			//ignore for now
		}
		
		/**
		 * Called when an agent starts Monitoring
		 * This is a crucial time to give Control to probekit
		 * so that it can send its commands.
		 * Therefore, we use this notification to pass control
		 * to the Probekit LaunchPad to send the necessary files beore the agent
		 * in question resumes.
		 */
		public void agentActive(IAgent agent)
		{
			try
			{
				String launchItemSelections = config.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_COLLECTOR_AND_ANALYSIS, (String)null);				// we do not want to giveControl to the probekit if this type of analysis
				// has not been selected
				if (launchItemSelections.indexOf("org.eclipse.tptp.analysisType.jvmti.probe")!=-1)
				{
					initializeLauncherHandlers();
					Object[] launcherHandlersArray = launcherHandlers.values().toArray();
					
	    	
					for (int num = 0; num < launcherHandlersArray.length; num++)
					{
						ILauncherHandler type = (ILauncherHandler)launcherHandlersArray[num];
	    		
						if (type instanceof org.eclipse.tptp.platform.probekit.launch.launchpad.LaunchPadExtensionSlot)
						{
							LaunchPadExtensionSlot extension = new LaunchPadExtensionSlot();
							extension.handlePreAgentActiveJVMTI(agent, config);
						}
						else
						{
							//inactive
						}
					}// end for
				}
			}
	    	catch (Exception e)
			{
	    		if(e.getMessage() != null)
	    		{
	    			IStatus status = new Status(IStatus.ERROR,UIPlugin.getPluginId(),IStatus.ERROR,e.getMessage(),e);
	        		UIPlugin.getDefault().getLog().log(status);    				
	    		}
	    			// log Exceptions
			}
		}
		/**
		 * Invoked when an agent becomes inactive.
		 * @param Agent
		 */
		public void agentInactive(IAgent agent)
		{
			//not necessary
		}
		
		/**
		 * A method which reads the extension points, and creates instances of the GetControlType objects
	     * specified by the class attribute. 
	     * @see org.eclipse.hyades.trace.ui.internal.piclient.PIProcessListener#initializeLauncherHandlers()
		 */
		private void initializeLauncherHandlers()
	    {
			launcherHandlers = new HashMap();
			
			IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(UIPlugin.PLUGIN_ID, "launcherHandler");
			if (point != null) 
			{
				IConfigurationElement[] elements = point.getConfigurationElements();
				for (int i = 0; i < elements.length; i++) 
				{
					IConfigurationElement elem = elements[i];
					String id = elem.getAttribute("id");								
					ILauncherHandler getControlType = null;
					try
					{
						getControlType = (ILauncherHandler)elem.createExecutableExtension("class");
					}
					catch (Exception e)
					{
		    			if(e.getMessage() != null)
		    			{
		    				IStatus status = new Status(IStatus.ERROR,UIPlugin.getPluginId(),IStatus.ERROR,e.getMessage(),e);
		        			UIPlugin.getDefault().getLog().log(status);    				
		    			}
						
						e.printStackTrace();
					}
					
					if(getControlType != null)			
					{
						//put the instance of the class in a map
						launcherHandlers.put(id, getControlType);					
					}
				}
			}
	    }// end method
		
}// end class
