/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal.launcher;

import java.util.Hashtable;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.agent.IAgentListener;
import org.eclipse.tptp.platform.execution.exceptions.InactiveProcessException;
import org.eclipse.tptp.platform.jvmti.client.internal.TIConstants;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.util.TIAgentUtil;
import org.eclipse.tptp.trace.ui.provisional.launcher.ICollectorFiltration;

/**
 * This filtration is used to exclude the TI's analysis types in the attach
 * scenario based on the library that the agent has been loaded with.
 * 
 * @author Ali Mehregani
 */
public class TIAnalysisTypeFiltration implements ICollectorFiltration
{
	private static Map cachedRuntimeConfig = new Hashtable();
	
	
	/**
	 * @see org.eclipse.tptp.trace.ui.provisional.launcher.ICollectorFiltration#include(java.lang.String, org.eclipse.debug.core.ILaunchConfiguration, java.lang.Object)
	 */
	public boolean include(String id, ILaunchConfiguration configuration, Object context)
	{		
		try
		{
			/* Return true if this is not an attach launch configuration item */
			if (!(context instanceof IAgent) && !TIConstants.CONFIGURATION_ATTACH_ID.equals(configuration == null ? null : configuration.getType().getIdentifier()))
				return true;
						
			final IAgent agent = (IAgent)context;
			long processId = -1;
			try
			{
				processId = agent.getProcess().getProcessId();
			} 
			catch (InactiveProcessException e)
			{
				// Ignore the exception
			}
			String key = processId > 0 ? String.valueOf(processId) : null;			
			if (key != null && cachedRuntimeConfig.get(key) != null)
			{
				return ((String)cachedRuntimeConfig.get(key)).equals(id);
			}
						
			String loadedAgentId = TIAgentUtil.getRuntimeConfig(agent);
			if (key != null)
			{
				cachedRuntimeConfig.put(key, loadedAgentId);				
			}
		
			return loadedAgentId.equals(id);
		} 
		catch (CoreException e)
		{
			UIPlugin.getDefault().log(e);
		} 

		
		
		return true;
	}
	
	public static void clearCache()
	{
		cachedRuntimeConfig.clear();
	}

}
