/**********************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal.launcher;

import java.util.Vector;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.tptp.platform.jvmti.client.internal.ITILaunchConfigurationConstants;
import org.eclipse.tptp.trace.ui.internal.launcher.application.AbstractConfiguration;
import org.eclipse.tptp.trace.ui.internal.launcher.application.FilterConfigurationPage;
import org.eclipse.tptp.trace.ui.internal.launcher.application.LimitsConfigurationPage;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;
import org.eclipse.tptp.trace.ui.provisional.launcher.IStatusListener;


/**
 * The configuration wizard for the TI data collector.  
 * 
 * @author Ali Mehregani
 */
public class TIConfiguration extends AbstractConfiguration
{

	/**
	 * Default constructor - Adds the filter page.
	 */
	public TIConfiguration()
	{
		super(new Class[]{TIFilterConfigurationPage.class, TILimitsConfigurationPage.class});	
	}

	
	/**
	 * This is the filter configuration page that will be displayed in 
	 * the configuration wizard for the TI data collector.
	 * 
	 * @author Ali Mehregani
	 */
	public static class TIFilterConfigurationPage extends FilterConfigurationPage
	{			
		public TIFilterConfigurationPage ()
		{
			super(ITILaunchConfigurationConstants.ATTR_FILTERSET_ID);
		}
	}
	/**
	 * This is a limits configuration page that will be displayed in the
	 * configuration wizard for the TI data collector
	 */
	public static class TILimitsConfigurationPage extends LimitsConfigurationPage{
		
		public TILimitsConfigurationPage ()
		{
			super ();
		}
		
	}
}
