/**********************************************************************
 * Copyright (c) 2006, 2007 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TIExtendedConfiguration.java,v 1.2 2007/08/22 04:40:20 gnagarajan Exp $
 * 
 **********************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal.launcher;

import org.eclipse.tptp.platform.jvmti.client.internal.ITILaunchConfigurationConstants;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.TIExtendedConfiguration.TIFilterExtendedConfigurationPage.TILimitsExtendedConfigurationPage;
import org.eclipse.tptp.trace.ui.internal.launcher.application.AbstractConfiguration;
import org.eclipse.tptp.trace.ui.internal.launcher.application.FilterExtendedConfigurationPage;
import org.eclipse.tptp.trace.ui.internal.launcher.application.LimitsConfigurationPage;


/**
 * The configuration wizard for the TI data collector that includes automatic
 * filters criteria determination
 * 
 * @author Alexander Simbirtsev
 */
public class TIExtendedConfiguration extends AbstractConfiguration
{
	public TIExtendedConfiguration() {
		super(new Class[] { TIFilterExtendedConfigurationPage.class, TILimitsExtendedConfigurationPage.class });
	}

	/**
	 * This is the filter configuration page that will be displayed in 
	 * the configuration wizard for the TI data collector.
	 * 
	 * @author Alexander Simbirtsev
	 */
	public static class TIFilterExtendedConfigurationPage extends FilterExtendedConfigurationPage {
		public TIFilterExtendedConfigurationPage() {
			super(ITILaunchConfigurationConstants.ATTR_FILTERSET_ID);
		}
	/**
	* This is the limits configuration page that will be displayed in the
	* configuration wizard for the TI data collector
	* Note that it is the same for all profile launch types (Extended and regular)
	*
	*/
	public static class TILimitsExtendedConfigurationPage extends LimitsConfigurationPage
	{
		
		public TILimitsExtendedConfigurationPage ()
		{
			super ();
		}
	}
}
}
