/**********************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;
import org.eclipse.tptp.platform.jvmti.client.internal.TIConstants;
import org.eclipse.tptp.trace.ui.internal.launcher.deleg.application.AbstractJavaDelegate;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorSelfManageableLauncher;
import org.eclipse.tptp.trace.ui.provisional.launcher.ProcessParameters;

/**
 * The self manageable launcher for local Java applications.
 * 
 * @author Ali Mehregani
 */
public class TIJavaLauncherDelegate extends AbstractJavaDelegate implements IDataCollectorSelfManageableLauncher, ILauncherParameterProvider
{
	public TIJavaLauncherDelegate() 
	{
		super(TIConstants.TI_AGENT_NAME, CommonUIConstants.PROFILE_AGENT_TYPE);	
	}

	public void launch(ILaunchConfiguration launchConfiguration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException 
	{
		TIDelegateHelper.getInstance().launch(this, launchConfiguration, mode, launch, monitor);
	}
	
	
	/**
	 * We need to add the TI flags	  
	 */
	public ProcessParameters getProcessParameters(ILaunchConfiguration launchConfiguration)
	{
		return TIDelegateHelper.getProcessParameter(super.getProcessParameters(launchConfiguration));
	}	
	
	
	/**
	 * Indicate that this is not a mutual launcher
	 */
	public boolean isMutualLauncher()
	{
		return false;
	}
	
	
	/** Expose the required methods */	
	public String getHostName()	{return super.getHostName(); }
	public int getPortNumber() {return super.getPortNumber(); }
	public String getLocation() {return super.getLocation(); }
	public String getClassPath() {return super.getClassPath(); }	
}
