/*******************************************************************************
 * Copyright (c) 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - Initial API and Implementation 
 * 	  
 * $Id: AgentMetaDataCommand.java,v 1.2 2007/04/27 21:15:15 gnagarajan Exp $
 *******************************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal.launcher.util;

import org.eclipse.tptp.platform.execution.util.internal.CommandElement;
import org.eclipse.tptp.platform.execution.util.internal.TPTPMessageUtil;
import org.eclipse.tptp.platform.execution.util.internal.TPTPString;
import org.eclipse.tptp.platform.execution.util.internal.TPTPXMLParse;
import org.eclipse.tptp.platform.jvmti.client.internal.TIConstants;

/**
 * The Agent meta data command is used to extract meta data from the
 * TI agent.
 */
public class AgentMetaDataCommand extends CommandElement
{
	protected String _agentName = null;
	protected String _commandData = null;

	public AgentMetaDataCommand(String agentname)
	{
		this._agentName = agentname;
		this._commandData = new String();
	}

	public void setCommandData(String command)
	{
		_commandData = new String(command);
	}

	public String getCommandData()
	{
		return this._commandData;
	}

	/**
	 * @see org.eclipse.tptp.platform.execution.util.internal.CommandElement#getSize()
	 */
	public int getSize()
	{
		return 0;
	}
	
	/**
	 * @see org.eclipse.tptp.platform.execution.util.internal.CommandElement#buildCommand()
	 */
	public String buildCommand()
	{
		StringBuffer sbuf = new StringBuffer();
		sbuf.append("<");
		sbuf.append(TIConstants.COMMAND_AGENT_METADATA + " iid=\"");
		sbuf.append(TIConstants.TI_AGENT_NAME + "\"");
		sbuf.append(">");
		//sbuf.append("<agentName>" + this._agentName);
		//sbuf.append("</agentName>");
		sbuf.append("</" + TIConstants.COMMAND_AGENT_METADATA + ">");
		// System.out.println("MetaData INput command "+sbuf.toString());
		return sbuf.toString();
	}

	/**
	 * @see org.eclipse.tptp.platform.execution.util.internal.CommandElement#readFromBuffer(byte[], int)
	 */
	public int readFromBuffer(byte[] buffer, int offset)
	{
		int current = offset;
		String retStr = null;
		current = TPTPMessageUtil.readTPTPStringFromBuffer(buffer, current, new TPTPString(retStr));
		// With the retStr value received parse the output for the specific
		// elements
		TPTPXMLParse ParseObj = new TPTPXMLParse();
		ParseObj.setParser(retStr);
		if (ParseObj.getHashTable().containsKey("AgentName"))
		{
			_agentName = (String) ((ParseObj.getHashTable()).get("AgentName"));
		}
		return current;

	}

	/**
	 * @see org.eclipse.tptp.platform.execution.util.internal.CommandElement#writeToBuffer(byte[], int)
	 */
	public int writeToBuffer(byte[] buffer, int offset)
	{
		int current = offset;
		current = TPTPMessageUtil.writeTPTPStringToBuffer(buffer, current, new TPTPString(this.buildCommand()));
		return current;
	}

}
