/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Stanislav Polevic, Intel - Initial API and Implementation 
 * 	  
 * $Id: SetOutputFormatCommand.java,v 1.2 2008/03/24 23:18:14 jkubasta Exp $ 
 *******************************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal.launcher.util;

import org.eclipse.tptp.platform.execution.util.internal.CommandElement;
import org.eclipse.tptp.platform.jvmti.client.internal.TIConstants;

/**
 * The run command is used to run agent.
 */
public class SetOutputFormatCommand extends CommandElement {

	/** Output formats */
	public static final String BINARY_FORMAT = "binary";
	public static final String XML_FORMAT = "xml";

	public static final String FORMAT_ELEMENT = "format";
	
	private static final String SET_OUTPUT_FORMAT_COMMAND = "setOutputFormat";

	
	private final String outputFormat;
	
	
	/**
	 * 
	 */
	public SetOutputFormatCommand(String outputFormat) {
		this.outputFormat = outputFormat;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.util.internal.CommandElement#getSize()
	 */
	public int getSize() {
		return 0;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.util.internal.CommandElement#readFromBuffer(byte[], int)
	 */
	public int readFromBuffer(byte[] buffer, int offset) {
		return 0;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.util.internal.CommandElement#writeToBuffer(byte[], int)
	 */
	public int writeToBuffer(byte[] buffer, int offset) {
		return 0;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.util.internal.CommandElement#buildCommand()
	 */
	public String buildCommand() {
		StringBuffer sbuf = new StringBuffer();
		sbuf.append("<");
		sbuf.append(SET_OUTPUT_FORMAT_COMMAND + " iid=\"");
		sbuf.append(TIConstants.TI_AGENT_NAME + "\"");
		sbuf.append("><");
		sbuf.append(FORMAT_ELEMENT);
		sbuf.append(">");
		sbuf.append(outputFormat);
		sbuf.append("</");
		sbuf.append(FORMAT_ELEMENT);
		sbuf.append(">");
		sbuf.append("</" + SET_OUTPUT_FORMAT_COMMAND + ">");
		return sbuf.toString();
	}

}
