/**********************************************************************
 * Copyright (c) 2007 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Intel - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal.launcher.util;

import java.util.Hashtable;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.core.INode;
import org.eclipse.tptp.platform.execution.client.core.internal.GenericCommandHandler;
import org.eclipse.tptp.platform.execution.exceptions.InactiveAgentException;
import org.eclipse.tptp.platform.execution.exceptions.NotConnectedException;
import org.eclipse.tptp.platform.execution.util.ICommandElement;
import org.eclipse.tptp.platform.execution.util.ICommandHandler;
import org.eclipse.tptp.platform.execution.util.internal.CommandFragment;
import org.eclipse.tptp.platform.execution.util.internal.TPTPXMLParse;
import org.eclipse.tptp.platform.jvmti.client.internal.TIConstants;

/**
 * A utility class that provides common methods that can be
 * used to extract or interact with the TI Agent.
 */
public class TIAgentUtil 
{
	/**
	 * Returns the configuration details of the TI agent
	 * 
	 * @param agent The TI agent
	 * @return The configuration details of the TI agent
	 */
	public static String getRuntimeConfig(IAgent agent) 
	{
		final GenericCommandHandler genCmdHandler = new GenericCommandHandler();			
		AgentMetaDataCommand command = new AgentMetaDataCommand(agent.getName());
		try
		{
			agent.sendCommand(command.buildCommand(), new ICommandHandler() 
			{
				public void incomingCommand(INode node, ICommandElement command) 
				{
					genCmdHandler.setCommandElement(command);
					//TIAgentUtil.class.notify();
				}
			});
		} 
		catch (InactiveAgentException e)
		{
			UIPlugin.getDefault().log(e);
			return null;
		} 
		catch (NotConnectedException e)
		{
			UIPlugin.getDefault().log(e);
			return null;
		}

		/* Block until a response to the command is received */
		synchronized(TIAgentUtil.class)
		{
			int currentCounter = 0;
			while (genCmdHandler.getCommandElement() == null && currentCounter < TIConstants.TOTAL_WAIT)
			{
				try
				{
					TIAgentUtil.class.wait(TIConstants.INCREMENTAL_WAIT);
					currentCounter++;
				} 
				catch (InterruptedException e)
				{
					UIPlugin.getDefault().log(e);
					return null;
				}
			}
		}
		
		if (!(genCmdHandler.getCommandElement() instanceof CommandFragment))
			return null;
		
		/* Parse the response */
		TPTPXMLParse ParseObj = new TPTPXMLParse();
		ParseObj.setParser( ((CommandFragment)genCmdHandler.getCommandElement()).getCommandData());
		Hashtable CommandHash = ParseObj.getHashTable();
		
		return "profilerName".equals(CommandHash.get("name")) ? (String)CommandHash.get("value") : null;		
	}
}
