/**********************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CustomAnalysisProvider.java,v 1.1 2010/04/20 19:56:10 jcayne Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.jvmti.client.provisional.extension;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.jvmti.client.internal.TIPlugin;

/**
* A utility class for the customAnalysisProvider extension point.
*
* Based on org.eclipse.tptp.platform.common.ui/src-common-internal/org/eclipse/hyades/ui/provisional/extension/CustomContentProvider.java
*/

public class CustomAnalysisProvider {
	
	/**
	 * The ID of the extension point.
	 */
	private final static String CUSTOM_ANALYSIS_PROVIDER_EXT_ID = TIPlugin.getId() + ".customAnalysisProvider";

	/**
	 * Provides access to the contributors for the customAnalysisProvider extension point.
	 * @return The registered plug-ins that use the extension point.
	 */
	public static ICustomAnalysisProvider[] getContributors() {
		IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(CUSTOM_ANALYSIS_PROVIDER_EXT_ID);
		List<ICustomAnalysisProvider> providers = new ArrayList<ICustomAnalysisProvider>();
		try {
			if(elements != null) {
				for (int configElement = 0; configElement < elements.length; configElement++) {
					ICustomAnalysisProvider provider = (ICustomAnalysisProvider) elements[configElement].createExecutableExtension("class");
					if(provider != null)
						providers.add(provider);
				}
			}
		} catch (CoreException e) {
			CommonPlugin.logError(e);
		}
		
		// Output the provider list to an array in order to return the result.
		ICustomAnalysisProvider[] providerArray = new ICustomAnalysisProvider[providers.size()];
		for(int i = 0; i < providers.size(); i++)
			providerArray[i] = (ICustomAnalysisProvider)providers.get(i);
		return providerArray;
	}

}
