/**********************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ICustomAnalysisProvider.java,v 1.4 2010/12/23 16:29:55 jcayne Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.jvmti.client.provisional.extension;

import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.swt.widgets.Button;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;

/**
 * An interface for the customAnalysisProvider extension point to provide a customized analysis launch configuration.
 */

public interface ICustomAnalysisProvider {
	
	/** 
	 * For org.eclipse.tptp.platform.jvmti.client/src/org/eclipse/tptp/platform/jvmti/client/internal/launcher/TIDelegateHelper.java
	 */
	
	/**
	 * Checks if the option selected and attribute name are set for the custom option of the launch configuration.
	 */
	public boolean checkAllocOptions(ILaunchConfiguration launchConfiguration, String optionCheck, String attributeName) throws CoreException;
	
	/**
	 * @return The ID of the custom option to check for allocation in the launch configuration.
	 */
	public String getAllocOptionToCheck();
	
	/**
	 * Provides the option to append to the JVM arguments if the custom option is selected.
	 * @param hasAttributes true if the JVM arguments already contains options and the custom option should 
	 * be appended to the list.
	 * @return The option to add to the JVM arguments.
	 */
	public String updateJVMArg(boolean hasAttributes);
	
	/**
	 * Provides the option add additional JVM arguments for the launch if the custom option is selected.
	 * If the argument contains a space, it should be contained in quotes.
	 * @return The additional JVM arguments.
	 */
	public List<String> addExtraJVMArgs();
	
	
	/**
	 * For org.eclipse.tptp.platform.jvmti.client/src/org/eclipse/tptp/platform/jvmti/client/internal/analysistypes/TIHeapAnalysisConfig.java
	 */
	
	/**
	 * @return The attribute information from the launch configuration.
	 */
	public DataCollectionEngineAttribute getAttribute();
	
	/**
	 * @return The value of the attribute selected in the launch configuration.
	 */
	public boolean getCollectAnalysisOption();
	
	/**
	 * @return A String to describe the launch configuration attribute.
	 */
	public String getLaunchConfigurationAttribute();
	
	/**
	 * Reset the analysis attribute to the default value for the given launch configuration.
	 * @param launchConfiguration
	 * @throws CoreException
	 */
	public void resetAttribute(ILaunchConfiguration launchConfiguration) throws CoreException;
	
	/**
	 * Using the information from the UI, determine if the option is selected and update the reference to the stored option. 
	 */
	public void updateAnalysisOption();
	
	
	/**
	 * For org.eclipse.tptp.platform.jvmti.client/src/org/eclipse/tptp/platform/jvmti/client/internal/analysistypes/TIHeapAnalysisUI.java
	 */
	
	/**
	 * Stores the button associated with the custom analysis option.
	 * The tooltip text should be set on the passed button to provide a description of the option.
	 */
	public void createAnalysisButton(Button analysisButton);
	
	/**
	 * @return The name of the button to be created.
	 */
	public String getButtonName();
	
	/**
	 * @return true if the button is selected, false otherwise.
	 */
	public boolean isCollectAnalysisSelected();
}
