/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: ServiceProxy.java,v 1.10 2005/10/12 01:24:10 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.automation.client;

import org.eclipse.hyades.automation.core.AbstractService;
import org.eclipse.hyades.automation.core.Service;
import org.eclipse.hyades.automation.core.utils.ProgressiveTask.Synchronicity;

/**
 * The client-side service proxy allows the interrogation and execution of an
 * automatable service witout having first instantiated a real concrete on on
 * the server (within Eclipse)
 * 
 * @author Scott E. Schneider
 */
class ServiceProxy extends AbstractService {

	/**
	 * Stream-Unique IDentifier (SUID) of this class.
	 */
	private static final long serialVersionUID = 4978070783347210157L;

	/**
	 * The automation client used for this service proxy
	 */
	private final transient AutomationClient context;

	/**
	 * The launch/execution strategy to use when launching and resolving the
	 * command's intent
	 */
	private final transient Service.Executable strategy;

	/**
	 * Constructs a service proxy instance given the automation client to use,
	 * the strategy to use and the identifier of the published service to
	 * execute
	 * 
	 * @param context
	 *            the automation client to use
	 * @param strategy
	 *            the strategy to use for launch and execution
	 * @param identifier
	 *            the identifier of the service to command/automate
	 */
	ServiceProxy(AutomationClient context, Service.Executable strategy, String identifier) {
		super(identifier);
		this.context = context;
		this.strategy = strategy;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.automation.core.Service#execute()
	 */
	public Object execute() {
		return this.execute(Synchronicity.SYNCHRONOUS);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.automation.core.Service#execute(org.eclipse.hyades.automation.core.Service.Synchronicity)
	 */
	public Object execute(Synchronicity synchronicity) {
		return this.strategy.execute(this, synchronicity);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.automation.core.Service#getRoot()
	 */
	public String getRoot() {
		return this.context.getRoot();
	}

}