/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: ICommandLineParameters.java,v 1.3 2005/11/07 00:16:39 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.automation.client.adapters.shell;

/**
 * The command line parameters interface, used simply as a collection of
 * constants and parameter strings used by the shell automation client adapter
 * package.
 * 
 * @author Duwayne J. Morris
 * @author Scott E. Schneider
 */
public interface ICommandLineParameters {

	public static final String CMD_ARG_FALSE = "false"; //$NON-NLS-1$

	public static final String CMD_ARG_TRUE = "true"; //$NON-NLS-1$

	public static final String CMD_CONFIGFILE = "configfile"; //$NON-NLS-1$

	public static final String CMD_CONFIGURATION = "configuration"; //$NON-NLS-1$

	public static final String CMD_CONNECTION = "connection"; //$NON-NLS-1$

	public static final String CMD_DASH = "-";//$NON-NLS-1$

	public static final String CMD_DEPLOYMENT = "deployment"; //$NON-NLS-1$

	public static final String CMD_ECLIPSEHOME = "eclipse"; //$NON-NLS-1$

	public static final String CMD_HELP1 = "?";//$NON-NLS-1$

	public static final String CMD_HELP2 = "-?";//$NON-NLS-1$

	public static final String CMD_HELP3 = "-help";//$NON-NLS-1$

	public static final String CMD_HELP4 = "--help";//$NON-NLS-1$

	public static final String CMD_OVERWRITE = "overwrite"; //$NON-NLS-1$

	public static final String CMD_PROJECT = "project"; //$NON-NLS-1$

	public static final String CMD_QUIET = "quiet"; //$NON-NLS-1$

	public static final String CMD_RESULTS = "results"; //$NON-NLS-1$

	public static final String CMD_SERVICEARGS = "serviceargs"; //$NON-NLS-1$

	public static final String CMD_SERVICENAME = "service"; //$NON-NLS-1$

	public static final String CMD_SUITE = "suite"; //$NON-NLS-1$

	public static final String CMD_SUITE_EXT = ".testsuite";//$NON-NLS-1$

	public static final String CMD_VMARGS = "vmargs"; //$NON-NLS-1$

	public static final String CMD_WORKSPACE = "workspace"; //$NON-NLS-1$

	public static final String COMMENT = "comment";//$NON-NLS-1$

	public static final int NUMPARMS = 14;

	public static final int PARM_CONFIGFILE = 8;

	public static final int PARM_CONFIGURATION = 13;

	public static final int PARM_CONNECTION = 11;

	public static final int PARM_DEPLOYMENT = 12;

	public static final int PARM_ECLIPSEHOME = 0;

	public static final int PARM_OVERWRITE = 5;

	public static final int PARM_PROJECT = 2;

	public static final int PARM_QUIET = 6;

	public static final int PARM_RESULTS = 4;

	public static final int PARM_SERVICEARGS = 10;

	public static final int PARM_SERVICENAME = 9;

	public static final int PARM_SUITE = 3;

	public static final int PARM_VMARGS = 7;

	public static final int PARM_WORKSPACE = 1;

	public static final String SERVICE_NAME = "org.eclipse.hyades.test.tools.core.execute"; //$NON-NLS-1$

}
