/********************************************************************** 
 * Copyright (c) 2005, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: InProcessStrategy.java,v 1.10 2008/04/28 15:45:40 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.automation.client.strategies;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.automation.core.Service;
import org.eclipse.hyades.automation.core.utils.ProgressiveTask;

/**
 * The in-process strategy, launches from within the same process as the caller,
 * and therefore reuses the same instance of eclipse that is already running,
 * the typical use case would be commanding an automatable service from within a
 * plug-in of eclipse where the desired execution environment is the same
 * instance of eclipse that the caller is in.
 * 
 * @author Scott E. Schneider
 */
class InProcessStrategy extends AbstractExecutionStrategy {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.automation.core.Service.Executable#execute(org.eclipse.hyades.automation.core.Service,
	 *      org.eclipse.hyades.automation.core.utils.ProgressiveTask.Synchronicity)
	 */
	public Object execute(Service service, ProgressiveTask.Synchronicity synchronicity) {

		/*
		 * Need to create an executable extension of the automation server
		 * application and then execute it directly without launching another
		 * instance of eclipse
		 */
		try {

			// Find service implementation for this service identifier
			IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.runtime.applications", //$NON-NLS-1$
					"org.eclipse.hyades.execution.server");//$NON-NLS-1$

			if (extension != null) {

				// Retrieve the extension point configuration elements
				IConfigurationElement[] elements = extension.getConfigurationElements();

				// Find the executable extension for application
				try {
					for (int i = 0; i < elements.length; i++) {
						IConfigurationElement element = elements[i];
						if (element.getName().equalsIgnoreCase("application")) {//$NON-NLS-1$
							element = element.getChildren("run")[0];//$NON-NLS-1$
							Object executableExtension = element.createExecutableExtension("class");//$NON-NLS-1$
							if (executableExtension instanceof IPlatformRunnable) {
								System.setProperty(AbstractExecutionStrategy.AUTOMATION_COMMAND_IDENTIFIER, "execute");//$NON-NLS-1$
								IPlatformRunnable runnable = (IPlatformRunnable) executableExtension;
								return runnable.run(service.createMemento());
							}
						}
					}
				} catch (CoreException e) {
					//
				}

			}

		} catch (Throwable t) {
			//
		}

		return null;

	}

}