/********************************************************************** 
 * Copyright (c) 2005, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: VoidStrategy.java,v 1.4 2008/04/28 15:45:40 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.automation.client.strategies;

import org.eclipse.hyades.automation.core.Service;
import org.eclipse.hyades.automation.core.utils.ProgressiveTask;

/**
 * The void strategy, does nothing on execution exception return an empty string
 * to the caller.
 * 
 * @author Scott E. Schneider
 */
class VoidStrategy extends AbstractExecutionStrategy {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.automation.core.Service.Executable#execute(org.eclipse.hyades.automation.core.Service,
	 *      org.eclipse.hyades.automation.core.utils.ProgressiveTask.Synchronicity)
	 */
	public Object execute(Service service, ProgressiveTask.Synchronicity synchronicity) {
		return ""; //$NON-NLS-1$
	}

}