/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Noop.java,v 1.1 2005/10/07 14:49:18 sschneid Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.automation.core.utils;

/**
 * A no operation class that has specific none run-time functional uses. It is
 * mainly used as compiler time to eliminate warnings or debug time to add
 * breakpoints in empty methods.
 * 
 * @author Scott E. Schneider
 */
public final class Noop {

	/**
	 * A none operation, usually called in debug situations
	 */
	public static void noop() {
	}

	/**
	 * A sink method, allows the argument to be referenced and therefore
	 * eliminate compiler warnings for cases where unreferenced variables are
	 * expected -- removed when this is no longer the case
	 * 
	 * @param object
	 *            the object to sink
	 */
	public static void sink(Object object) {
	}

	/**
	 * A sink method, allows the arguments to be referenced and therefore
	 * eliminate compiler warnings for cases where unreferenced variables are
	 * expected -- removed when this is no longer the case
	 * 
	 * @param objectA
	 *            an object to sink
	 * @param booleanA
	 *            an boolean to sink
	 */
	public static void sink(Object objectA, boolean booleanA) {
	}

	/**
	 * A sink method, allows the arguments to be referenced and therefore
	 * eliminate compiler warnings for cases where unreferenced variables are
	 * expected -- removed when this is no longer the case
	 * 
	 * @param objectA
	 *            an object to sink
	 * @param objectB
	 *            an object to sink
	 */
	public static void sink(Object objectA, Object objectB) {
	}

	/**
	 * A sink method, allows long to be referenced and therefore eliminate
	 * compiler warnings
	 * 
	 * @param longA
	 */
	public static void sink(long longA) {
	}

	/**
	 * Intended for static use only
	 */
	private Noop() {
	}

}
