/**********************************************************************
Copyright (c) 2005, 2008 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id:

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.execution;

import org.eclipse.tptp.platform.agentcontroller.config.AgentControllerEnvironment;
import org.eclipse.tptp.platform.agentcontroller.config.Option;
import org.eclipse.tptp.platform.agentcontroller.config.PluginConfig;
import org.eclipse.tptp.platform.agentcontroller.config.SetConfigSkeleton;
import org.eclipse.tptp.platform.agentcontroller.config.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetConfig extends SetConfigSkeleton {

	public void askUser() {
	}

	public void generateConfiguration() {
		Document doc;
		Element holder;
		Element pConfig;

		Element aEnv;
		Element option;
		Element var;

		//
		// Standard initializer 
		//
		doc = configFile.getDoc();
		if(doc == null) {
			return;
		}

		pConfig = doc.createElement(PluginConfig.TAG);
		holder = configFile.getHolder();
		holder.appendChild(pConfig);

		//
		// Plugin specific information
		//
		aEnv = doc.createElement(AgentControllerEnvironment.TAG);
		AgentControllerEnvironment.setConfiguration(aEnv, "default");//$NON-NLS-1$
		pConfig.appendChild(aEnv);

		//
		// Provides
		//

		// Bug 89383 begins
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");//$NON-NLS-1$
		Variable.setPosition(var, "prepend");//$NON-NLS-1$
		Variable.setValue(var, "%PLUGINS_HOME%" + sr + getPluginName() + sr + "hexcore.jar");//$NON-NLS-1$//$NON-NLS-2$
		aEnv.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");//$NON-NLS-1$
		Variable.setPosition(var, "prepend");//$NON-NLS-1$
		Variable.setValue(var, "%PLUGINS_HOME%" + sr + getPluginName() + sr + "hexl.jar");//$NON-NLS-1$//$NON-NLS-2$
		aEnv.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");//$NON-NLS-1$
		Variable.setPosition(var, "prepend");//$NON-NLS-1$
		Variable.setValue(var, "%PLUGINS_HOME%" + sr + getPluginName() + sr + "hexr.jar");//$NON-NLS-1$//$NON-NLS-2$
		aEnv.appendChild(var);
		// Bug 89383 ends
		
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH");//$NON-NLS-1$
		Variable.setPosition(var, "append");//$NON-NLS-1$
		Variable.setValue(var, "%CLASSPATH_COM_IBM_ICU%");//$NON-NLS-1$
		aEnv.appendChild(var); 

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH_ORG_ECLIPSE_HYADES_EXECUTION");//$NON-NLS-1$
		Variable.setPosition(var, "append");//$NON-NLS-1$
		Variable.setValue(var, "%PLUGINS_HOME%" + sr + getPluginName() + sr + "hexcore.jar");//$NON-NLS-1$//$NON-NLS-2$
		aEnv.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH_ORG_ECLIPSE_HYADES_EXECUTION");//$NON-NLS-1$
		Variable.setPosition(var, "append");//$NON-NLS-1$
		Variable.setValue(var, "%PLUGINS_HOME%" + sr + getPluginName() + sr + "hexl.jar");//$NON-NLS-1$//$NON-NLS-2$
		aEnv.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH_ORG_ECLIPSE_HYADES_EXECUTION");//$NON-NLS-1$
		Variable.setPosition(var, "append");//$NON-NLS-1$
		Variable.setValue(var, "%PLUGINS_HOME%" + sr + getPluginName() + sr + "hexr.jar");//$NON-NLS-1$//$NON-NLS-2$
		aEnv.appendChild(var);

		//
		// The following can be reused for other plugins
		//
		option = doc.createElement(Option.TAG);
		Option.setType(option, "version");//$NON-NLS-1$
		if(getPluginName().indexOf('_') != -1) {
			Option.setName(option, getPluginName().substring(0, getPluginName().lastIndexOf('_')));
			Option.setValue(option, getPluginName().substring(getPluginName().lastIndexOf('_') + 1));
		}
		else {
			Option.setName(option, getPluginName());
			Option.setValue(option, "unknown");//$NON-NLS-1$
		}
		pConfig.appendChild(option);

		configFile.saveToFile();
	}

	public void printHelp() {
	}

	public void printExamples() {
	}

}
