package org.eclipse.hyades.execution.core;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionComponentStateChangeEvent.java,v 1.2 2005/02/25 22:17:09 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

public class ExecutionComponentStateChangeEvent {
	
	private IExecutionComponent target;
	private int state;
	
	public ExecutionComponentStateChangeEvent(IExecutionComponent comp, int state) {
		target=comp;
		this.state=state;
	}

	public int getState() {
		return state;
	}
	
	public IExecutionComponent getComponent() {
		return target;
	}
}
