/**********************************************************************
 * Copyright (c) 2006 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionPlugin.java,v 1.2 2008/03/20 18:49:56 dmorris Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.core;

import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ExecutionPlugin extends AbstractUIPlugin {
	public static String PLUGIN_ID = "org.eclipse.hyades.execution";//$NON-NLS-1$
	public static String AC_CONFIG_EXTENTION_POINT = "acConfig";//$NON-NLS-1$

	/*
	 * Aliases
	 */
	private static int APPLICATION = 0;
	private static int BUNDLE_CLASSPATH = 1;
	private static int BUNDLE_PATH = 2;
	private static int JAVA_PROPERTY = 3;
	private static int SYSTEM_ENVIRONMENT = 4;

	private static int NUM_ALIASES = 5;
	private static String[] _aliases = new String[NUM_ALIASES];

	private static ExecutionPlugin _instance;
	private IPreferenceStore _preferenceStore;

	private boolean _errorOccurred = false; /* Bug 145856 */

	static {
		_aliases[APPLICATION] = "$A(";//$NON-NLS-1$
		_aliases[BUNDLE_CLASSPATH] = "$C(";//$NON-NLS-1$
		_aliases[BUNDLE_PATH] = "$P(";//$NON-NLS-1$
		_aliases[JAVA_PROPERTY] = "$J(";//$NON-NLS-1$
		_aliases[SYSTEM_ENVIRONMENT] = "$E(";//$NON-NLS-1$
	}

	public ExecutionPlugin() {
		super();
		_instance = this;
		_preferenceStore = getPreferenceStore();
	}
	
	public ExecutionPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		_instance = this;
		_preferenceStore = getPreferenceStore();
	}

	public boolean getBoolean(String name) {
		return _preferenceStore.getBoolean(name);
	}

	public boolean getDefaultBoolean(String name) {
		return _preferenceStore.getDefaultBoolean(name);
	}

	public int getDefaultInt(String name) {
		return _preferenceStore.getDefaultInt(name);
	}

	public String getDefaultString(String name) {
		return _preferenceStore.getDefaultString(name);
	}

	public static ExecutionPlugin getInstance()
	{
		return _instance;
	}

	public int getInt(String name) {
		return _preferenceStore.getInt(name);
	}

	public String getString(String name) {
		return _preferenceStore.getString(name);
	}

	public boolean isErrorOccurred() { /* Bug 145856 */
		return _errorOccurred;
	}


	/**
	 * Resolve any predefined variables enclosed by the "%" char
	 * @param str
	 * @return A new string with the "%" enclosed variable subsituted
	 */
	public String resolveVariable(String str) {
		String result = str;
		boolean done = false;
		int start = 0; // start index
		int end = result.length() - 1; // stop index

		while(!done) {
			start = result.indexOf('%', 0);
			if(start != -1) { // found the first '%' char
				end = start + 1;
				if(end < result.length()) {
					end = result.indexOf('%', end);
					if(end != -1) {
						if(end - start > 1) {
							String alias = result.substring(start + 1, end); // do not include the '%' chars
							String value = getString(alias);

							if(value != null) {
								StringBuffer strbuf = new StringBuffer();
								strbuf.append(result.substring(0, start));
								strbuf.append(value);
								strbuf.append(result.substring(end + 1));
								result = strbuf.toString();
								// result = result.replaceAll("%" + alias + "%", value);
							}
							else {
								// canot substitute - leave the alias as-is
							}

							start = end + 1;
							end = start + 1;
							if(end >= result.length()) {
								done = true;
							}
						}
						else {
							done = true; // cannot substitute since it is a "%%" sequence
						}
					}
					else {
						done = true; // cannot find the matching '%' in the remaining bytes
					}
				}
				else {
					done = true; // cannot find the matching '%' since the end of string has been reached
				}
			}
			else {
				done = true; // no more '%' in the string
			}
		}
		
		return result;
	}

	protected void setErrorOccurred(boolean error) { /* Bug 145856 */
		_errorOccurred = error;
	}

	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	public void stop(BundleContext context) throws Exception {
		super.stop(context);
	}

}
