/**********************************************************************
Copyright (c) 2005, 2008 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: IControlMessage.java,v 1.3 2008/03/20 18:49:56 dmorris Exp $

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
	SCAPA Technologies - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

/**
 * This interface is a simple abstraction for passing control events between
 * the workbench and the remote IExecutionComponents.
 */

public interface IControlMessage {
	
	public static final String START = "START";//$NON-NLS-1$
	
	public static final String STOP = "STOP";//$NON-NLS-1$
	
	/**
	 * @param data The string representing the control event of this message. 
	 */
	public void setMessageData(String data);
	
	/**
	 * @return The string representing the control event of this message.
	 */
	public String getMessageData();

}
