/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDataProcessor.java,v 1.2 2005/02/25 22:17:09 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.core;


public interface IDataProcessor {
	/**
	 * @param buffer byte[]
	 * @param length int
	 * @param peer java.net.InetAddress
	 */
	void incommingData(byte[] buffer, int length, java.net.InetAddress peer);
	/**
	 * @param buffer char[]
	 * @param length int
	 * @param peer java.net.InetAddress
	 */
	void incommingData(char[] buffer, int length, java.net.InetAddress peer);
	/**
	 * @param data byte[]
	 * @param length int
	 * @param peer java.net.InetAddress
	 */
	void invalidDataType(byte[] data, int length, java.net.InetAddress peer);
	/**
	 * Creation date: (10/3/00 5:54:46 PM)
	 */
	void waitingForData();
}
