/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: IExecutionComponentFactory.java,v 1.2 2005/02/25 22:17:09 hleung Exp $

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
	SCAPA Technologies - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

/**
 * This interface defines a factory for IExecutionComponents.  The mechanism by 
 * which this factory is extended to support multiple implementations of the 
 * same execution component type has not yet been resolved.
 * @version 0.0.2
 */
public interface IExecutionComponentFactory {
	
	/**
	 * @param type The type of execution component to create
	 * @return IExecutionComponent The created IExecutionComponent
	 */
	public IExecutionComponent createExecutionComponentByType(String type);
	
	/**
	 * Loads a type into the factory's creation table.  This routine will
	 * determine if the implementation class is available in the appropriate
	 * locations.  If the factory is responsible for creating remote instances
	 * tehn it needs to check both the local and the remote classpaths for the 
	 * implementation class.
	 * @param type the name that this type will be referend to in the future.
	 * @param implClass the classname of the implementation class.  the implementation
	 * class, stub, and skeleton must all have default constructors.
	 * @throws ClassNotFoundException if the class is not available in any of the
	 * locations where it is required.
	 */
	public void addExecutionComponent(String type, String implClass) throws ClassNotFoundException;
	
	/**
	 * Specifies the stub to use for a specific type.  The type first needs to be 
	 * specified with the <code>addExecutionComponent</code> method.  This method 
	 * checks the classpath of the local JVM.
	 * @param type
	 * @param stubClass
	 * @throws ClassNotFoundException if the class cannot be found locally
	 */
	public void addStub(String type, String stubClass) throws ClassNotFoundException;
	
	/**
	 * Specifies the skeleton class to use when invoking the implementation class 
	 * remotely.  This method must be called after the <code>addExecutionComponent</code> 
	 * method.  This method will check the classpath on the remote JVM to ensure the class
	 * is available.
	 * @param type
	 * @param skeletonClass
	 * @throws ClassNotFoundException if the class cannot be located on the remotre JVM
	 */
	public void addSkeleton(String type, String skeletonClass) throws ClassNotFoundException;
	
	public ISession getSessionContext();

}
