/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: ISession.java,v 1.2 2005/02/25 22:17:09 hleung Exp $

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
	SCAPA Technologies - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

/**
 *
 * <p>A session is the abstraction of a connection with a remote node.
 * Sessions are created by the node and are scoped by a Principal.
 * Therefore, a single workbench instance may have many sessions, one
 * for each Principal.  Tools access the session in context of a Principal,
 * when a tool is completed with a session it should release it so that the
 * reference count can be decremented.  Sessions are the highest level 
 * IExecutionComponent on the workbench side.</p>
 * @version 0.0.2
 */
public interface ISession extends IExecutionComponent {
	
	/**
	 *  Release this session so that it can be cleaned up and destroyed
	 *  if no other tools are using it.
	 */ 
	public void release();

}
