/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MessageDeliveryException.java,v 1.4 2005/10/08 14:28:50 sschneid Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.core;

/**
 * @author rduggan
 * 
 */
public class MessageDeliveryException extends Exception {

	/**
	 * Stream-Unique IDentifier (SUID) of this class
	 */
	private static final long serialVersionUID = -6479708390586359310L;

	private Throwable cause;

	/**
	 * 
	 */
	public MessageDeliveryException() {
		super();
	}

	/**
	 * @param description
	 */
	public MessageDeliveryException(String description) {
		super(description);
	}

	public MessageDeliveryException(String description, Throwable cause) {
		super(description);
		this.cause = cause;
	}

	public MessageDeliveryException(Throwable cause) {
		this.cause = cause;
	}

	public Throwable getCause() {
		return cause;
	}
}
