/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JavaExecutionEnvironment.java,v 1.3 2008/03/20 18:49:53 dmorris Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.core.impl;

import java.io.File;

import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IOrderedProperty;
import org.eclipse.hyades.execution.core.internal.resources.CoreResourceBundle;
import org.eclipse.osgi.util.NLS;

/**
 * @author jtoomey
 */
public class JavaExecutionEnvironment extends ExecutionEnvironmentImpl {

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.impl.ExecutionEnvironmentImpl#setEnv(org.eclipse.hyades.execution.core.IOrderedProperty)
	 */
	public void setEnv(IOrderedProperty env) 
		throws ExecutionComponentStateException 
	{
		super.setEnv(env);
		
		// If the environment variable that is being set is the "CLASSPATH"
		// variable, set the system classpath variable to this value.
		// (this will be picked up by our custom class loader and
		// used to load the classes needed by the test.)
		if ( env.getName().equalsIgnoreCase("classpath"))//$NON-NLS-1$
		{
			// TODO: check to make sure there is only one property.
			// May need to create a semicolon separated string from
			// array, though we won't use that ourselves. 
			System.setProperty("java.class.path", ((String) env.getValues()[0]));//$NON-NLS-1$
			System.out.println(NLS.bind(CoreResourceBundle.JavaExecutionEnvironment_SET_CLASSPATH_, ((String) env.getValues()[0])));
		}
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IExecutionEnvironment#addEnv(org.eclipse.hyades.execution.core.IOrderedProperty)
	 */
	public void addEnv(IOrderedProperty env)
		throws ExecutionComponentStateException {
		// TODO Auto-generated method stub
		super.addEnv(env);
		System.out.println(CoreResourceBundle.JavaExecutionEnvironment_GET_CALLED_);
		
		// If the environment variable that is being set is the "CLASSPATH"
		// variable, set the system classpath variable to this value.
		// (this will be picked up by our custom class loader and
		// used to load the classes needed by the test.)
		if ( env.getName().equalsIgnoreCase("classpath"))//$NON-NLS-1$
		{
			// Append to the existing value.
			String origClasspath = System.getProperty("java.class.path", ".");//$NON-NLS-1$
			StringBuffer buf = new StringBuffer(origClasspath);
			buf.append(File.pathSeparatorChar);
			buf.append((String)env.getValues()[0]);
			
			// TODO: check to make sure there is only one property.
			// May need to create a semicolon separated string from
			// array, though we won't use that ourselves. 
			System.setProperty("java.class.path", buf.toString());//$NON-NLS-1$
			System.out.println(NLS.bind(CoreResourceBundle.JavaExecutionEnvironment_SET_CLASSPATH_NOW_, System.getProperty("java.class.path")));
		}
	}

}
