
/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JavaTaskExecutableObject.java,v 1.3 2008/03/20 18:49:53 dmorris Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.core.impl;

import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.internal.resources.CoreResourceBundle;

/**
 * @author rduggan
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class JavaTaskExecutableObject implements IJavaTaskExecutableObject {

	private IExecutor executor;
	private String name; 
	private Thread jobRunnerThread;
	
	public void init() {
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutableObject#getName()
	 */
	public String getName() {
		return name;
	}

	/** 
	 * @see org.eclipse.hyades.execution.core.IExecutableObject#setExecutor(org.eclipse.hyades.execution.core.IExecutor)
	 */
	public void setExecutor(IExecutor obj) {
		this.executor=obj;
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutableObject#getExecutor()
	 */
	public IExecutor getExecutor() {
		return executor;
	}
	
	public void run() {
		// TODO: Call the actual test here!

		System.out.println(CoreResourceBundle.JavaTaskExecutableObject_DEFAULT_BEHAVIOUR_);
		
	}
	
	public void stop() {
		if(jobRunnerThread!=null && jobRunnerThread.isAlive()) {
			jobRunnerThread.stop();
		}
	}
	
	public void start() {
		
		Runnable job= new Runnable() {
			public void run() {
				JavaTaskExecutableObject.this.run();
			}
		}; 
		/* create a thread to run this job on */
		jobRunnerThread=new Thread(job, "JavaTaskExecutableObject Runner");//$NON-NLS-1$
		jobRunnerThread.start();
	}
}
