/**********************************************************************
Copyright (c) 2005, 2008 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: JavaTaskExecutorImpl.java,v 1.3 2008/03/20 18:49:53 dmorris Exp $

Contributors:
 IBM Corporation - initial implementation
**********************************************************************/
package org.eclipse.hyades.execution.core.impl;

import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.IProcessConsole;
import org.eclipse.hyades.execution.core.internal.resources.CoreResourceBundle;

/**
 * 
 */
public class JavaTaskExecutorImpl extends ExecutionComponentImpl implements IExecutor {

	private IExecutableObject executable;
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#launch()
	 */
	public void launch() throws ExecutionComponentStateException {
		checkConfiguration();
		((IJavaTaskExecutableObject)executable).start();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#kill()
	 */
	public void kill() throws ExecutionComponentStateException {
		checkConfiguration();
		((JavaTaskExecutableObject)executable).stop();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#setExecutableObject(org.eclipse.hyades.execution.core.IExecutableObject)
	 */
	public void setExecutableObject(IExecutableObject theExecutableObject) throws ExecutionComponentStateException {
		executable=theExecutableObject;
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#getExecutableObject()
	 */
	public IExecutableObject getExecutableObject()
	{
		return executable;
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#getProcessConsole()
	 */
	public IProcessConsole getProcessConsole()
		throws ExecutionComponentStateException {
		return null;
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutor#getCompatibleExecutableObject()
	 */
	public IExecutableObject getCompatibleExecutableObject(String classname) throws ClassNotFoundException {
		throw new UnsupportedOperationException(CoreResourceBundle.JavaTaskExecutorImpl_IMPLEMENTED_OPERATION_);
	}

	/**
	 * Insure this executor has been been appropriately configured for the
	 * requested operation.
	 * 
	 * @throws ExecutionComponentStateException
	 */	
	protected void checkConfiguration() throws ExecutionComponentStateException {
		if ( executable == null )
			throw new ExecutionComponentStateException(
			IExecutionComponent.NOT_CONFIGURED,
			CoreResourceBundle.JavaTaskExecutorImpl_NOT_CONFIGURED_EXECUTOR_);
		if ( !(executable instanceof IJavaTaskExecutableObject ) )
			throw new ExecutionComponentStateException(
			IExecutionComponent.NOT_CONFIGURED,
			CoreResourceBundle.JavaTaskExecutorImpl_NOT_RIGHT_OBJECT_);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IExecutor#supportsControlEvent(java.lang.String)
	 */
	public boolean supportsControlEvent(String controlEvent) {
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IExecutor#performControlEvent(java.lang.String)
	 */
	public String performControlEvent(String controlEvent, String[] params) {
		return "";
	}

}
