/**********************************************************************
Copyright (c) 2005, 2008 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: JavaTaskRemoteHyadesComponentImpl.java,v 1.3 2008/03/20 18:49:53 dmorris Exp $

Contributors:
 IBM Corporation - initial implementation
**********************************************************************/
package org.eclipse.hyades.execution.core.impl;

import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IDataChannel;
import org.eclipse.hyades.execution.core.IDataProcessor;
import org.eclipse.hyades.execution.core.IRemoteHyadesComponent;
import org.eclipse.hyades.execution.core.TimeoutException;
import org.eclipse.hyades.execution.core.internal.resources.CoreResourceBundle;

/**
 * At present, this class does not provide much functionality. Most of the
 * monitoring operations are implemented entirely in the stub layer.
 */
public class JavaTaskRemoteHyadesComponentImpl extends ExecutionComponentImpl implements IRemoteHyadesComponent {
	
	/**
	 * This method is implemented in the stub layer.
	 * 
	 * @see org.eclipse.hyades.execution.core.IRemoteHyadesComponent#isActive()
	 */
	public boolean isActive() {
		throw new UnsupportedOperationException(CoreResourceBundle.JavaTaskRemoteHyadesComponentImpl_IMPLEMENTED_METHOD_IN_STUB_);
	}

	/**
	 * This method is implemented in the stub layer.
	 * 
	 * @see org.eclipse.hyades.execution.core.IRemoteHyadesComponent#isMonitored()
	 */
	public boolean isMonitored() {
		throw new UnsupportedOperationException(CoreResourceBundle.JavaTaskRemoteHyadesComponentImpl_IMPLEMENTED_METHOD_IN_STUB_);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IRemoteHyadesComponent#isLocked()
	 */
	public boolean isLocked() {
		/* This is actually implemented in the stub/skeleton.  The stub/skeleton
		 * uses this class as a delegate and can hense lock the object entirely
		 * without each subclass having to do this explictly on each method.
		 */
		throw new UnsupportedOperationException(CoreResourceBundle.JavaTaskRemoteHyadesComponentImpl_IMPLEMENTED_METHOD_IN_STUB_);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IRemoteHyadesComponent#lock(long)
	 */
	public void lock(long timeout) throws TimeoutException {
		/* This is actually implemented in the stub/skeleton.  The stub/skeleton
		 * uses this class as a delegate and can hense lock the object entirely
		 * without each subclass having to do this explictly on each method.
		 */
		throw new UnsupportedOperationException(CoreResourceBundle.JavaTaskRemoteHyadesComponentImpl_IMPLEMENTED_METHOD_IN_STUB_);
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IRemoteHyadesComponent#unlock()
	 */
	public void unlock() {
		/* This is actually implemented in the stub/skeleton.  The stub/skeleton
		 * uses this class as a delegate and can hense lock the object entirely
		 * without each subclass having to do this explictly on each method.
		 */
		throw new UnsupportedOperationException(CoreResourceBundle.JavaTaskRemoteHyadesComponentImpl_IMPLEMENTED_METHOD_IN_STUB_);
	}

	/**
	 * This method is implemented in the stub layer.
	 * 
	 * @see org.eclipse.hyades.execution.core.IRemoteHyadesComponent#startMonitoring(org.eclipse.hyades.execution.core.IDataChannel)
	 */
	public void startMonitoring(IDataChannel processor)
		throws ExecutionComponentStateException {
		throw new UnsupportedOperationException(CoreResourceBundle.JavaTaskRemoteHyadesComponentImpl_NOT_IMPLEMENTED_OPERATION_);
	}

	/**
	 * This method is implemented in the stub layer.
	 * 
	 * @see org.eclipse.hyades.execution.core.IRemoteHyadesComponent#stopMonitoring()
	 */
	public void stopMonitoring() throws ExecutionComponentStateException {
		throw new UnsupportedOperationException(CoreResourceBundle.JavaTaskRemoteHyadesComponentImpl_IMPLEMENTED_METHOD_IN_STUB_);
	}
	
	/**
	 * This method is implemented in the stub layer.
	 * 
	 * @see org.eclipse.hyades.execution.core.IRemoteHyadesComponent#startMonitoring(org.eclipse.hyades.execution.core.IDataProcessor)
	 */
	public void startMonitoring(IDataProcessor processor) throws ExecutionComponentStateException {
		throw new UnsupportedOperationException(CoreResourceBundle.JavaTaskRemoteHyadesComponentImpl_IMPLEMENTED_METHOD_IN_STUB_);
	}

}
