/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: OrderedPropertyImpl.java,v 1.4 2005/10/08 14:28:52 sschneid Exp $

Contributors:
 IBM Corporation - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

import org.eclipse.hyades.execution.core.IOrderedProperty;

/**
 * @author IBM
 *
 * This is an implementation for the IOrderedProperty interface.
 */
public class OrderedPropertyImpl implements IOrderedProperty, Serializable {

	/**
	 * Stream-Unique IDentifier (SUID) of this class
	 */
	private static final long serialVersionUID = 1489705956752554896L;
	protected String name;
	protected Vector values;


	/**
	 * Constructor for OrderedPropertyImpl. Will call init().
	 *
	 */
	public OrderedPropertyImpl() {
		name=null;
		values=new Vector();
	}


	/**
	 * Set the name of the OrderedPropertyImpl.
	 * @param name0 Name of the property
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Get the name of the OrderedPropertyImpl.
	 * @return String
	 */
	public String getName() {
		return name;
	}

	/**
	 * Append a value to the property.
	 * @param value The value to be appended
	 */
	public void appendValue(Object value) {
		values.add(value);
	}

	/**
	 * Prepend a value to the property.
	 * @param value The value to be prepended
	 */
	public void prependValue(Object value) {
		values.insertElementAt(value, 0);
	}

	/**
	 * Get all the values associated to this property.
	 * @return An array of property values
	 */
	public Object[] getValues() {
		return values.toArray();
	}

	/**
	 * Clear all entries in the property.
	 * @return Entries erased
	 */
	public Object[] clear() {
		Object[] prev = values.toArray();
		values.removeAllElements();
		return prev;
	}

	/**
	 * Duplicate the object.
	 * @return A clone of this object
	 */
	public synchronized Object clone() throws CloneNotSupportedException {
		OrderedPropertyImpl clone=new OrderedPropertyImpl();
		clone.name=this.name;
		for(int i=0; i<this.values.size(); i++) {
			clone.appendValue(this.values.elementAt(i));
		}
		return clone;
	}
	
	private synchronized void writeObject(java.io.ObjectOutputStream out) throws IOException {
		out.defaultWriteObject();
	}
	 private synchronized void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
	 	in.defaultReadObject();
	 	
	 }
}
