/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: ProcessExecutableObjectImpl.java,v 1.2 2005/02/25 22:17:09 hleung Exp $

Contributors:
 IBM Corporation - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core.impl;

import org.eclipse.hyades.execution.core.IExecutor;


/**
 * @author IBM
 *
 * This is an implementation of the IExecutableObject
 */
public class ProcessExecutableObjectImpl implements IProcessExecutableObject {

	private IExecutor executor;
	private String name;
	private String exe;
	private String args;
	private String location;
	private String agentData;

	public void init() {
	}

	/**
	 * Set the name of the ExecutableObjectImpl
	 * @return Name
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecutableObject#getExecutor()
	 */
	public IExecutor getExecutor() {
		return executor;
	}

	/** 
	 * @see org.eclipse.hyades.execution.core.IExecutableObject#setExecutor(org.eclipse.hyades.execution.core.IExecutor)
	 */
	public void setExecutor(IExecutor obj) {
		this.executor=obj;
	}

	/**
	 * Get the name of the ExecutableObjectImpl
	 * @param _name Name
	 */
	public void setName(String _name) {
		name = _name;
	}

	/**
	 * Set the physical name of the executable
	 * @param _exe Executable name
	 */
	public void setExe(String _exe) {
		exe = _exe;
	}

	/**
	 * Get the physical name of the executable
	 * @return Executable name
	 */
	public String getExe() {
		return exe; 
	}

	/**
	 * Set the command line arguments without the executable
	 * @param _args The command line arguments separated by space
	 */
	public void setArgs(String _args) {
		args = _args;
	}

	/**
	 * Get the command line arguments without the executable
	 * @return All command line arguments
	 */
	public String getArgs() {
		return args;
	}

	/**
	 * Set the location where the ExecutableObjectImpl should be run (working directory)
	 * @param _location The location to run the ExecutableObjectImpl
	 */
	public void setLocation(String _location) {
		location = _location;
	}

	/**
	 * Get the location where the ExecutableObjectImpl should be run (working directory)
	 * @return Location
	 */
	public String getLocation() {
		return location;
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.impl.IProcessExecutableObject#getAgentData()
	 */
	public String getAgentData()
	{
		return agentData;
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.impl.IProcessExecutableObject#setAgentData(java.lang.String)
	 */
	public void setAgentData(String data)
	{
		agentData = data;
	}

	/**
	 * Get the complete command line
	 * @return The command line
	 */
	public String getCommandLine() {
		if(getExe().indexOf(" ") == -1) { // If no space within the exe
			return new String(getExe() + " " + getArgs());
		}
		else { // If there is at least a space in the exe
			return new String("\"" + getExe() + "\" " + getArgs());
		}
	}
}
