/**********************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: 
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.core.internal.resources;

import org.eclipse.osgi.util.NLS;

/**
 * Core resource bundle.
 * <p>
 * 
 * 
 * @author      Tony Wang
 * @author      Paul E. Slauenwhite
 * @version     April 26, 2008
 * @since       March 13, 2008
 */
public final class CoreResourceBundle extends NLS {

	private static final String BUNDLE_NAME = "org.eclipse.hyades.execution.core.internal.resources.messages";//$NON-NLS-1$

	private CoreResourceBundle() {
		// Do not instantiate
	}

	public static String ExecutionComponentImpl_NO_HANDLER_EXCEPTION_;
	public static String ExecutioncomponentImpl_CLASS_SEND_MESSAGE_EXCEPTION_;
	
	public static String JavaExecutionEnvironment_SET_CLASSPATH_;
	public static String JavaExecutionEnvironment_SET_CLASSPATH_NOW_;
	public static String JavaExecutionEnvironment_GET_CALLED_;
	
	public static String JavaTaskExecutableObject_DEFAULT_BEHAVIOUR_;
	
	public static String JavaTaskExecutorImpl_IMPLEMENTED_OPERATION_;
    public static String JavaTaskExecutorImpl_NOT_CONFIGURED_EXECUTOR_;
    public static String JavaTaskExecutorImpl_NOT_RIGHT_OBJECT_;
    
    public static String JavaTaskRemoteHyadesComponentImpl_IMPLEMENTED_METHOD_IN_STUB_;
    public static String JavaTaskRemoteHyadesComponentImpl_NOT_IMPLEMENTED_OPERATION_;
    
    public static String ProcessExecutorImpl_LAUNCH_ERROR_;
    public static String ProcessExecutorImpl_NO_STANDARD_INPUT_STREAM_;
    public static String ProcessExecutorImpl_NO_STANDARD_OUTPUT_STREAM_;
    public static String ProcessExecutorImpl_NO_STANDARD_ERROR_STREAM_;
	public static String ProcessExecutorImpl_CONSOLE_INPUT_CLOSED_;
	public static String ProcessExecutorImpl_CONSOLE_OUTPUT_CLOSED_;
	public static String ProcessExecutorImpl_CONSOLE_ERROR_CLOSED_;
	
	public static String Test_TEST_COMPLETE_;
	
	public static String CallData_CANNOT_FIND_TARGET_OBJECT_;
	
	public static String Marshaller_EXPECTED_CLASS_;
	public static String Marshaller_EXPECTED_OBJECT_;
	public static String Marshaller_EXPECTED_STRING_;
    public static String Marshaller_TIMEOUT_;
    
    public static String RemoteObjectReference_MISSING_REMOTE_OBJECT_;
    
    public static String UpdateablePathClassLoader_CANNOT_OPEN_FILE_;
    public static String UpdateablePathClassLoader_CANNOT_READ_FILE_;
    public static String UpdateablePathClassLoader_CANNOT_FIND_RESOURCE_;
    
    public static String AbstractFileServerCommand_NO_BEHAVIOUR_DEFINED_;

    public static String DeleteDirectoryCommand_IDENTIFIED_REMOVED_;
    public static String DeleteDirectoryCommand_NOT_IDENTIFIED_REMOVED_;
    
    public static String DeleteFileCommand_IDENTIFIED_REMOVED_;
    public static String DeleteFileCommand_NOT_IDENTIFIED_REMOVED_;

    public static String FileServerCommandFactory_TIME_TO_WAIT_;
    
    public static String GetFileCommand_IDENTIFIED_SENT_;
    
    public static String PutFileCommand_IDENTIFIED_RECEIVED_;
        
	static {
		NLS.initializeMessages(BUNDLE_NAME, CoreResourceBundle.class);
	}
}
