/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Test.java,v 1.3 2008/03/20 18:49:57 dmorris Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.execution.core.task;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.execution.core.internal.resources.CoreResourceBundle;

/**
 * A test class that exercises progress tasks and the related underlying
 * classes.
 * 
 * @author Scott E. Schneider
 */
public class Test {

    private static int count = 0;

    public static void main(String[] args) {

        ProgressiveTask task = new ProgressiveTask("Test", new Runnable() {//$NON-NLS-1$
            public void run() {
                for (int i = 0; i < 1000000000; i++) {
                    if (i % 100000000 == 0) {
                        System.out.println(java.lang.Thread.currentThread()
                                + " -- " + i);
                    }
                }
            }
        }, new NullProgressMonitor() {
            public boolean isCanceled() {
                Test.count++;
                return count > 5;
            }
        });

        task.execute(ProgressiveTask.Synchronicity.SYNCHRONOUS);

        System.out.println(CoreResourceBundle.Test_TEST_COMPLETE_);

    }
}