/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IPerformanceTimer.java,v 1.3 2005/09/21 20:51:31 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.execution.core.timer;

/**
 * Performance timer interface for lightweight timer functionality for debug
 * purposes
 * 
 * @author Scott E. Schneider
 */
public interface IPerformanceTimer {
	/**
	 * Calculates and then uses the elapsed time details, average is computed
	 * for cases where the nested count is greater than zero
	 */
	public void elapsed();

	/**
	 * Calculates and then uses the elapsed time details, average is computed
	 * for cases where the nested count is greater than zero
	 * 
	 * @param size
	 *            the size of the work completed within the elapsed time, the
	 *            elapsed time will be divided by this number, for an indication
	 *            of time per work unit
	 */
	public void elapsed(int size);

	/**
	 * Resets the performance timer attributes of a given performance timer
	 * instance
	 */
	public void reset();

	/**
	 * Starts a performance timer task with no task name given, a nested FILO
	 * scheme is used, the when the stop method is called the most recently
	 * started timer task is stopped
	 */
	public void start();

	/**
	 * Starts a performance timer task with a the given task name used, uses a
	 * FILO approach, first timer task started in the last stop in order
	 * 
	 * @param name
	 *            the named timer task to start
	 */
	public void start(String name);

	/**
	 * Stops the performance timer task, FILO approach, first timer task started
	 * is the last stopped, the performance timer keeps the memory
	 */
	public void stop();
}
