/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CallData.java,v 1.3 2008/03/20 18:50:01 dmorris Exp $
 * 
 * Contributors: 
 * IBM Rational - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.invocation;

import org.eclipse.hyades.execution.core.internal.resources.CoreResourceBundle;


/**
 * Instances of this type store data pertaining to a method call that is
 * to be marshalled or unmarshalled.
 */
public class CallData extends MarshalData {
	private Object[] callArgs;

	/**
	 * This constructor should be used to collect the representation of a method
	 * call that has been unmarshalled.
	 * 
	 * @param targetId the unique id associated with the target object
	 * @param argTypes the list of types matching those declared as parameters
	 *        in the signature of <code>call</code> 
	 * @param callArgs the arguments of <code>call</code>
	 * @param call the method that is to be invoked
	 */
	public CallData(Integer targetId, Class[] argTypes, Object[] callArgs, String call){
		super(targetId, argTypes, call);
		this.callArgs = callArgs;
	}

	/**
	 * Get the list of actual parameters to be used in the method invocation.
	 * 
	 * @return an array of <code>Object</code>s if the method to be invoked
	 *         accepts parameters, or <code>null</code> if the method does not
	 *         accept parameters.
	 */
	public Object[] getCallArgs() {
		return callArgs;
	}

	/**
	 * Get the instance that is the target of the method invocation.
	 * 
	 * @return an <code>Object</code>
	 */
	public Object getTarget() {
		Object target = Marshaller.getInstanceFromMap(targetId);
		if ( target == null )
			throw new IllegalStateException(CoreResourceBundle.CallData_CANNOT_FIND_TARGET_OBJECT_);
		return target;
	}

}
