/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RemoteInvocationException.java,v 1.4 2005/10/08 14:28:51 sschneid Exp $
 * 
 * Contributors: 
 * IBM Rational - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.invocation;

/**
 * Methods that can be remotely invoked should declare this exception in the
 * <code>throws</code> clause.
 */
public class RemoteInvocationException extends RuntimeException {

	/**
	 * Stream-Unique IDentifier (SUID) of this class
	 */
	private static final long serialVersionUID = -4427900461983465988L;

	protected Throwable cause;

	/**
	 * @param message
	 *            a description of the condition that caused this exception to
	 *            be thrown
	 */
	public RemoteInvocationException(String message) {
		super(message);
	}

	/**
	 * @param message
	 *            a description of the condition that caused this exception to
	 *            be thrown
	 * @param cause
	 *            a <code>Throwable</code> that represents the underlying
	 *            cause of this exception having been thrown
	 */
	public RemoteInvocationException(String message, Throwable cause) {
		super(message);
		this.cause = cause;
	}

	/**
	 * @param cause
	 *            a <code>Throwable</code> that represents the underlying
	 *            cause of this exception having been thrown
	 */
	public RemoteInvocationException(Throwable cause) {
		this.cause = cause;
	}

	/**
	 * @return a <code>Throwable</code> that represents the underlying cause
	 *         of this exception having been thrown
	 */
	public Throwable getCause() {
		return cause;
	}

}
