/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RemoteObjectReference.java,v 1.5 2008/03/20 18:50:01 dmorris Exp $
 * 
 * Contributors: 
 * IBM Rational - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.invocation;

import java.io.Serializable;

import org.eclipse.hyades.execution.core.internal.resources.CoreResourceBundle;

/**
 * This type serves as a remote object reference. When remote objects are passed
 * as method arguments, they are passed by reference. Custom input and output
 * serialization streams make use of insances of this type.
 */
public class RemoteObjectReference implements Serializable {

	/**
	 * Stream-Unique IDentifier (SUID) of this class
	 */
	private static final long serialVersionUID = 8482526991256501398L;

	private Integer uniqueId;

	/**
	 * Create a reference to the remote object associated with
	 * <code>uniqueId</code>
	 * 
	 * @param uniqueId
	 */
	public RemoteObjectReference(Integer uniqueId) {
		this.uniqueId = uniqueId;
	}

	/**
	 * Get the object referred to by this reference.
	 * 
	 * @return
	 */
	public Object getReferencedObject() {
		Object refObj = Marshaller.getInstanceFromMap(uniqueId);
		if (refObj == null)
			throw new IllegalStateException(CoreResourceBundle.RemoteObjectReference_MISSING_REMOTE_OBJECT_);
		return refObj;
	}

}
