/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RemoteReferenceOutputStream.java,v 1.2 2005/02/25 22:17:09 hleung Exp $
 * 
 * Contributors: 
 * IBM Rational - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.invocation;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

/**
 * This stream type is used to marshal method calls for remote invocation.
 * When remote objects are encountered, a <code>RemoteObjectReference</code>
 * is written to the stream in place of the remote object. This transparently
 * enables pass by reference semantics for remote objects. All other objects
 * are passed by value. 
 */
public class RemoteReferenceOutputStream extends ObjectOutputStream {

	/**
	 * @param out
	 * @throws java.io.IOException
	 */
	public RemoteReferenceOutputStream(OutputStream out) throws IOException {
		super(out);
		init();
	}

	/**
	 * @throws java.io.IOException
	 * @throws java.lang.SecurityException
	 */
	public RemoteReferenceOutputStream()
		throws IOException, SecurityException {
		super();
		init();
	}
	
	private void init() throws SecurityException {
		enableReplaceObject(true);
	}

	/**
	 * Replace instances of <code>IRemoteObject</code> with a
	 * <code>RemoteObjectReference</code>.
	 * 
	 * @see java.io.ObjectOutputStream#replaceObject(java.lang.Object)
	 */
	protected Object replaceObject(Object obj) throws IOException {
		if ( !(obj instanceof IRemoteObject) )
			return super.replaceObject(obj);
		return new RemoteObjectReference(((IRemoteObject)obj).getUniqueId());
	}

}
