/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This
 * program and the accompanying materials are made available under the terms of
 * the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html $Id:
 * AbstractFileManipulationCommand.java,v 1.1 2005/05/03 14:32:54 sschneid Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/

package org.eclipse.hyades.internal.execution.core.file;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.Cookie;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.FileIdentifierList;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.Option;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;

/**
 * An abstract file manipulation command, a general class of commands that
 * manipulate files on the server side, for example, the delete file command is
 * a subclass of the abstract file manipulation command.
 * 
 * @author Scott E. Schneider
 */
abstract class AbstractFileManipulationCommand extends AbstractFileServerCommand implements IFileManipulationCommand {

	/**
	 * The client class for the abstract file manipulation command
	 * 
	 * @author Scott E. Schneider
	 */
	abstract class Client extends AbstractFileServerCommand.Client {

		/**
		 * Constructs a client given the socket channel to use
		 * 
		 * @param channel
		 *            the channel to communicate with the server
		 */
		Client(ISocketChannel channel) {
			super(channel);
		}

	}

	/**
	 * The server class for the abstract file manipulation command
	 * 
	 * @author Scott E. Schneider
	 */
	abstract class Server extends AbstractFileServerCommand.Server {

		/**
		 * Constructs a server given the socket channel to use
		 * 
		 * @param channel
		 *            the channel to communicate with the client on
		 */
		Server(ISocketChannel channel) {
			super(channel);
		}

	}

	/**
	 * Remote identifiers as operands in the abstract file manipulation class of
	 * commands
	 */
	FileIdentifierList remoteIdentifiers;

	/**
	 * Constructs an abstract file manipulation command given the identity as a
	 * class type
	 * 
	 * @param identity
	 *            the class of the command
	 */
	AbstractFileManipulationCommand(Class identity) {
		super(identity);
	}

	/**
	 * Constructs an abstract file manipulation command given the identity,
	 * cookie and monitor arguments
	 * 
	 * @param identity
	 *            the identity of the command
	 * @param cookie
	 *            the cookie, the unique command instance identity
	 * @param monitor
	 *            the progress monitor used for abstract file manipulation
	 *            command progress and cancel control
	 */
	AbstractFileManipulationCommand(Class identity, Cookie cookie, IProgressMonitor monitor) {
		super(identity, cookie, Option.NONE, monitor);
		this.remoteIdentifiers = null; // need to derive from given cookie
	}

	/**
	 * Constructs an abstract file manipulation command given the identity,
	 * remote identifier operand list and progress monitor
	 * 
	 * @param identity
	 *            the identity of the command
	 * @param remoteIdentifiers
	 *            the remote identifiers operand list
	 * @param monitor
	 *            the progress monitor progress and cancel control callback
	 */
	AbstractFileManipulationCommand(Class identity, FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) {
		super(identity, Cookie.NONE, Option.NONE, monitor);
		this.remoteIdentifiers = remoteIdentifiers;
	}

}