/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: AbstractServerInterrogationCommand.java,v 1.6 2005/09/21 20:51:30 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.execution.core.file;

import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;

/**
 * Superclass to commands that inspect the server itself rather than the files
 * managed by the server, this is basically more of a meta file server command
 * rather than a file server command.
 * 
 * @author Scott E. Schneider
 */
abstract class AbstractServerInterrogationCommand extends AbstractFileServerCommand implements IServerInterrogationCommand {

	/**
	 * The client side state for the abstract server interrogation command
	 * 
	 * @author Scott E. Schneider
	 */
	abstract class Client extends AbstractFileServerCommand.Client {

		/**
		 * Constructs a client given the channel to communicate with the server
		 * 
		 * @param channel
		 *            the channel to communicate with the server
		 */
		Client(ISocketChannel channel) {
			super(channel);
		}

	}

	/**
	 * The server side state for the abstract server interrogation command
	 * 
	 * @author Scott E. Schneider
	 */
	abstract class Server extends AbstractFileServerCommand.Server {

		/**
		 * Constructs a server given the channel to communicate with the client
		 * on
		 * 
		 * @param channel
		 *            the channel to communicate with the client on
		 */
		Server(ISocketChannel channel) {
			super(channel);
		}

	}

	/**
	 * Constructs an abstract server interrogation command given the command
	 * identity
	 * 
	 * @param identity
	 *            the identity of the command
	 */
	AbstractServerInterrogationCommand(Class identity) {
		super(identity);
	}

}
