/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: ICommand.java,v 1.3 2005/05/20 22:53:09 jptoomey Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.execution.core.file;

import java.io.IOException;

/**
 * An interface to support the command pattern, used to execute based on the
 * current state of the command.
 * 
 * @author Scott E. Schneider
 */
public interface ICommand {
	/**
	 * Execute using the current state of the command, the command encapsulates
	 * what this exactly means at run-time
	 */
	public void execute() throws IOException;
}
