/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IQueryServerStatusCommand.java,v 1.3 2005/09/14 23:38:03 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.execution.core.file;

/**
 * The query server status command interface, a specialized server interrogation
 * command used to execute a simple test from client to server and back to the
 * client again -- one method for determining the result of the command is
 * available
 * 
 * @author Scott E. Schneider
 */
public interface IQueryServerStatusCommand extends IServerInterrogationCommand {
	/**
	 * Indicates if the server is available, used to query the server
	 * availability status after the command has executed and attempted server
	 * interrogation
	 * 
	 * @return
	 */
	public boolean isServerAvailable();
}
