/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: ModifyPermissionCommand.java,v 1.6 2005/09/14 23:38:03 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.execution.core.file;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.FileIdentifierList;

/**
 * The modify permission command, used for modifying permissions of file or
 * group of files on the server, a modify permission command is a specialized
 * file manipulation command
 * 
 * @author Scott E. Schneider
 */
class ModifyPermissionCommand extends AbstractFileManipulationCommand implements IModifyPermissionCommand {

	/**
	 * Constructs a modify permission command given the remote identifier
	 * operands, a permission directive and a progress monitor
	 * 
	 * @param remoteIdentifiers
	 *            identifies the files to operate on
	 * @param permissionDirective
	 *            the permission directive interpreted by the server and applied
	 *            to the file operands
	 * @param monitor
	 *            the progress monitor supporting progress reporting and cancel
	 *            support
	 */
	ModifyPermissionCommand(FileIdentifierList remoteIdentifiers, String permissionDirective, IProgressMonitor monitor) {
		super(ModifyPermissionCommand.class, remoteIdentifiers, monitor);
	}

}
