/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This
 * program and the accompanying materials are made available under the terms of
 * the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html $Id:
 * FileServerParametersLegacy.java,v 1.1 2005/05/03 15:51:14 samwai Exp $
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.hyades.internal.execution.core.file;

/**
 * The file server is not available and therefore a connection can not be
 * created to it.
 * 
 * @author Scott E. Schneider
 */
public class ServerNotAvailableException extends Exception {

	/**
	 * Stream-Unique IDentifier (SUID) of this class
	 */
	private static final long serialVersionUID = 3256445806793143862L;

	/**
	 * Constructs a new server not available exception that was not triggered by
	 * another exception
	 */
	public ServerNotAvailableException() {
		super();
	}

	/**
	 * Constructs a new server not available exception that was triggered by
	 * another exception
	 * 
	 * @param throwable
	 *            the throwable that this exception is triggered from
	 */
	public ServerNotAvailableException(Throwable throwable) {
		super(throwable);
	}

}