/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ChannelCommunicatorFactory.java,v 1.1 2005/09/21 20:51:32 sschneid Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.internal.execution.core.file.communicator;

import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

/**
 * A channel communicator factory creates channel communicators, communicators
 * are objects that encapsulate and abstract the low-level communication details
 * of sending and receiving data between readable and writable channels.
 * 
 * @author Scott E. Schneider
 */
public final class ChannelCommunicatorFactory implements IChannelCommunicatorFactory {

	/**
	 * The singleton channel communicator factory
	 */
	private static final IChannelCommunicatorFactory factory;

	/**
	 * Create and store the singleton instance, not using on demand creation,
	 * always create on class load
	 */
	static {
		factory = new ChannelCommunicatorFactory();
	}

	/**
	 * Singleton accessor method
	 * 
	 * @return the singleton communicator factory instance
	 */
	public static IChannelCommunicatorFactory getInstance() {
		return ChannelCommunicatorFactory.factory;
	}

	/**
	 * Limit instantiation to same class for singleton pattern
	 */
	private ChannelCommunicatorFactory() {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.internal.execution.core.file.communicator.IChannelCommunicatorFactor
	 *      #create(java.nio.channels.ReadableByteChannel,
	 *      java.nio.channels.WritableByteChannel)
	 */
	public IChannelCommunicator create(ReadableByteChannel readableChannel, WritableByteChannel writableChannel) {
		return new ChannelCommunicator(readableChannel, writableChannel);
	}

}