/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IChannelCommunicatorFactory.java,v 1.1 2005/09/21 20:51:32 sschneid Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.internal.execution.core.file.communicator;

import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

/**
 * A channel communicator factory creates channel communicators, communicators
 * are objects that encapsulate and abstract the low-level communication details
 * of sending and receiving data between readable and writable channels.
 * 
 * @author Scott E. Schneider
 */
public interface IChannelCommunicatorFactory {
	/**
	 * Creates a new channel communicator instance using the specified channels
	 * as the readable and writable conduits respectively
	 * 
	 * @param readableChannel
	 *            the channel that receives incoming communication
	 * @param writableChannel
	 *            that channel that sends outgoing communication
	 * @return the concrete channel communicator ready to use
	 */
	public IChannelCommunicator create(ReadableByteChannel readableChannel, WritableByteChannel writableChannel);
}