/********************************************************************** 
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: AbstractFileInspectionCommand.java,v 1.3 2006/04/06 15:28:01 samwai Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.execution.core.file.dynamic;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.Cookie;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.FileIdentifierList;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.Option;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;

/**
 * A superclass to all file inspection commands, file inspection command are
 * file server commands that operate on one set of files on the side of the file
 * server.
 * 
 * @author Scott E. Schneider
 */
abstract class AbstractFileInspectionCommand extends AbstractFileServerCommand
		implements IFileInspectionCommand {

	/**
	 * The client side personality of the abstract file inspection command
	 * 
	 * @author Scott E. Schneider
	 */
	abstract class Client extends AbstractFileServerCommand.Client {

		/**
		 * Constructs client side state using the given channel to communicate
		 * with the server
		 * 
		 * @param channel
		 *            the channel to communicate with the server on
		 */
		Client(ISocketChannel channel) {
			super(channel);
		}

	}

	/**
	 * The server side personality of the abstract file inspection command
	 * 
	 * @author Scott E. Schneider
	 */
	abstract class Server extends AbstractFileServerCommand.Server {

		/**
		 * Constructs server side state using the given channel to communicate
		 * with the client
		 * 
		 * @param channel
		 *            the channel to communicate with the client on
		 */
		Server(ISocketChannel channel) {
			super(channel);
		}

	}

	/**
	 * Remote identifiers as operands in the abstract file inspection class of
	 * commands
	 */
	FileIdentifierList remoteIdentifiers;

	/**
	 * Constructs an abstract file inspection command given the identity as a
	 * class type
	 * 
	 * @param identity
	 *            the class of the command
	 */
	AbstractFileInspectionCommand(String context, Class identity) {
		super(context, identity);
	}

	/**
	 * Constructs an abstract file inspection command given the identity, cookie
	 * and monitor arguments
	 * 
	 * @param context
	 *            the context this command is executing within
	 * @param identity
	 *            the identity of the command
	 * @param cookie
	 *            the cookie, the unique command instance identity
	 * @param monitor
	 *            the progress monitor used for abstract file inspection command
	 *            progress and cancel control
	 */
	AbstractFileInspectionCommand(String context, Class identity,
			Cookie cookie, IProgressMonitor monitor) {
		super(context, identity, cookie, Option.NONE, monitor);
		this.remoteIdentifiers = null; // need to derive from given cookie
	}

	/**
	 * Constructs an abstract file inspection command given the identity, remote
	 * identifier operand list and progress monitor
	 * 
	 * @param context
	 *            the context this command is executing within
	 * @param identity
	 *            the identity of the command
	 * @param remoteIdentifiers
	 *            the remote identifiers operand list
	 * @param monitor
	 *            the progress monitor progress and cancel control callback
	 */
	AbstractFileInspectionCommand(String context, Class identity,
			FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) {
		super(context, identity, Cookie.NONE, Option.NONE, monitor);
		this.remoteIdentifiers = remoteIdentifiers;
	}

}