/********************************************************************** 
 * Copyright (c) 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IDetermineServerReachCommand.java,v 1.1 2006/07/29 01:57:50 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.execution.core.file.dynamic;

/**
 * The determine server reach command determines if the file server's host can
 * connect back to a particular host using an IP and port combination.
 * 
 * @author Scott E. Schneider
 */
public interface IDetermineServerReachCommand extends
		IServerInterrogationCommand {

	/**
	 * Indicates whether the particular IP and port combination is reachable
	 * (used to determine if any firewall or other problems are blocking a
	 * successful connection to the server socket on the given IP address and
	 * port.
	 * 
	 * @return true if the specified host successfully accepts a connection from
	 *         the file system services machine to the given port, false
	 *         indicates a timeout or exception occurred and it is not possible
	 *         at this time
	 */
	public boolean isHostReachable();
}
