/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IFileServerCommand.java,v 1.1 2005/09/21 20:51:29 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.execution.core.file.dynamic;

/**
 * An interface that all file server commands implement, it also extends from
 * the general command interface to support the implementation of the command
 * design pattern
 * 
 * @author Scott E. Schneider
 */
public interface IFileServerCommand extends ICommand {
	/**
	 * Disposes the resources associated with the implementing command, used to
	 * clean up after a command is no longer required and before it goes
	 * unreferenced and garbage collected; an example, release network resources
	 * such as locks or database connections or UI handles to fully cleanup
	 */
	public void dispose();
}
