/********************************************************************** 
 * Copyright (c) 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IValidateDirectoryExistenceCommand.java,v 1.1 2006/02/14 23:45:40 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.execution.core.file.dynamic;

/**
 * The delete directory command interface, highlighting the hierarchy of the
 * command structure
 * 
 * @author Scott E. Schneider
 */
public interface IValidateDirectoryExistenceCommand extends
		IFileInspectionCommand {
	/**
	 * Returns back the result to the operation directed to determine if the
	 * given remote identifiers associated with this command found the
	 * directories to exist (and therefore be valid directories as well)
	 * 
	 * @return an array that is a parallel to the remote identifier list passed
	 *         in to the command's constructor
	 */
	public boolean[] isDirectoryExistent();
}
